/*
 * Userspace program that communicates with the vga_ball device driver primarily through ioctls
 * Control the game logic, including the infomation generation of all obejcts, movement, collision detection
 * Zhenyu Zhu Fang Fang Jiaxuan Shang Xiao Xiao 
 * StarWars
 * CSEE4840 Embedded Systems Design Spring 2014
 * Columbia University
 */

#include <stdio.h>
#include <stdlib.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include "usbkeyboard.h"
#include "movement.h"
#include "collision.h"
#include <time.h>
/////////////////////define entity//////////////////////////////////////////
# define NO_ID 0
# define SPACESHIP 1
# define BULLET 2
# define SPAWN 3
# define ENEMY4 4
# define ENEMY5 5
# define ENEMY6 6
# define ENEMY7 7
# define EXPLOSION_BULLET 11
# define EXPLOSION_SPACESHIP 12
/////////////////////////define direction//////////////////////////////////////
# define LEFT 0
# define LEFTUP 1
# define UP 2
# define RIGHTUP 3
# define RIGHT 4
# define RIGHTDOWN 5
# define DOWN 6
# define LEFTDOWN 7
# define A 22695477
# define B 12983942
# define C 1

struct libusb_device_handle * keyboard;
uint8_t endpoint_address;

int vga_ball_fd;

/* Read and print the segment values */
void print_directions_info() {
	vga_ball_arg_t vla;
	int i;
	for (i = 0; i < 256; i++) { 
		vla.axis = i;
		if (ioctl(vga_ball_fd, VGA_BALL_READ_AXIS, & vla)) {
			perror("ioctl(VGA_BALL_READ_AXIS) failed");
			return;
		}
		printf("%02x ", vla.direction);
	}
	printf("\n");
}

/* Write the contents of the array to the display */
void write_directions(const unsigned int directions[256]) 
{
	vga_ball_arg_t vla;
	int i;
	for (i = 0; i < 256; i++)
	{ 	vla.axis = i;
		vla.direction = directions[i];
		if (ioctl(vga_ball_fd, VGA_BALL_WRITE_AXIS, & vla)) {
			perror("ioctl(VGA_BALL_WRITE_AXIS) failed");
			return;
		}
	}
}
/*random_number_generation*/
unsigned int random_number_generation_x() {
	unsigned int random_num;
	random_num = rand() % 580 + 1;
	if (random_num <= 32) {
		random_num = 32;
	}
	return random_num;
}
unsigned int random_number_generation_y() {
	unsigned int random_num;
	random_num = rand() % 440 + 1;
	if (random_num <= 32) {
		random_num = 32;
	}
	return random_num;
}

int main() {
	int counter_bullet = 0;
	int n;
	int j, k;
	int flag_bullet = 0;
	int flag_spawn = 0;
	int random_tmp_x = 0;
	int random_tmp_y = 0;
	int spaceship_counter = 0;
	int spawn_counter = 0;
	int counter = 30;
	int movecounter = C;

	int over = 0;
	unsigned int * point_message;
	unsigned int * point_message2;
	unsigned int collision_result;
	unsigned int counter_wait;
	int VGA_audio_collision = 0;
	//signals for player/game info
	int life = 3; //message[240] storing life
	int score = 0; //message[241] storing score
	int bomb = 0; //message[242] storing bomb
	int bomb_status = 0; //used to eliminate button shake infulence
	int game_over = 0; //message[255] storing game_over
	int recounter = 0; //restart game counter
	int h = 0, t = 0, d = 0; //converting scores
	int start = 0; //start game
	int dr = 0; //move  right
	int dd = 0; //move  down

	int temp = 0;
	struct usb_keyboard_packet packet;
	int transferred;
	char keystate[12];
	srand(time(NULL));

	/* Open the keyboard */
	if ((keyboard = openkeyboard( & endpoint_address)) == NULL) {
		fprintf(stderr, "Did not find a keyboard\n");
		exit(1);
	}

	vga_ball_arg_t vla;
	int left, leftup, up, leftdown, down, rightdown, right, rightup;
	int left_d, leftup_d, up_d, leftdown_d, down_d, rightdown_d, right_d, rightup_d;
	int clear_key = 1;

	static const char filename[] = "/dev/vga_ball";
	static unsigned int message[256] = {SPACESHIP, 320, 240, 0 }; 
	message[240] = 3; //initialize life
	message[242] = 3; //initialize bomb

	//===================================================================
	//end of message initialization
	//===================================================================

	printf("VGA BALL Userspace program started\n");

	if ((vga_ball_fd = open(filename, O_RDWR)) == -1) {
		fprintf(stderr, "could not open %s\n", filename);
		return -1;
	}

	printf("initial state: ");
	print_directions_info();
	write_directions(message);
	printf("current state: ");
	print_directions_info();

	//for loop for starting a new game
	for (;;) {
		//initialize score, life, bomb and message;
		d = 0;
		t = 0;
		h = 0;
		life = 3;
		score = 0;
		bomb = 0;
		bomb_status = 0;
		game_over = 1;
		start = 0;
		static unsigned int message[256] = {SPACESHIP, 320, 240, 0};
		message[240] = 3; //initialize life
		message[242] = 1; //initialize bomb
		message[244] = 0; //initialize collision audio flag
		message[246] = 0;
		message[247] = 0;
		message[248] = 0;
		message[255] = 1;
		//----------end of initialization-------------

		/* Look for any keypresses from the game controller*/
		for (;;) {
			if (message[240] == 0) { //sending game_over message
				for (recounter = 4; recounter < 240; recounter = recounter + 4) {
					message[recounter] = NO_ID;
				}
				message[244] = 0;
				message[255] = 1;
				if (packet.keycode[4]==0x01||packet.keycode[4]==0x02||packet.keycode[4]==0x08||packet.keycode[4]==0x20||packet.keycode[4]==0x04||packet.keycode[4]==0x10) //Restart new game
	
					break;
			}
			if (message[0] == 0) {
				message[0] = 1;
			}
			libusb_interrupt_transfer(keyboard, endpoint_address, (unsigned char * ) & packet, sizeof(packet), & transferred, 0);
			if (transferred == sizeof(packet)) {
				sprintf(keystate, "%02x %02x %02x %02x %02x %02x %02x %02x", packet.modifiers, packet.reserved, packet.keycode[0], packet.keycode[1], packet.keycode[2], packet.keycode[3], packet.keycode[4], packet.keycode[5]);
				printf("%s\n", keystate);
				if ((packet.modifiers == 0x7f && packet.reserved == 0x7f && packet.keycode[0] == 0x00 && packet.keycode[1] == 0x80 &&
					packet.keycode[2] == 0x80 && packet.keycode[3] == 0x0f && packet.keycode[4] == 0x00 && packet.keycode[5] == 0x00) || clear_key == 1) {
					left = 0;
					leftup = 0;
					up = 0;
					leftdown = 0;
					down = 0;
					rightdown = 0;
					right = 0;
					rightup = 0;
					left_d = 0;
					leftup_d = 0;
					up_d = 0;
					leftdown_d = 0;
					down_d = 0;
					rightdown_d = 0;
					right_d = 0;
					rightup_d = 0;
					bomb = 0;
				}
				/*BOMB BUTTON DETECTION*/
				if (packet.keycode[4] == 0x08 && message[242] != 0 && bomb == 0 && bomb_status < 30) {
					bomb_status = bomb_status + 1;
					if (bomb_status == 30) {
						bomb_status = 0;
						bomb = 1;
						message[242] = message[242] - 1;
					}
				}
				/*Start a new game*/
				if (packet.keycode[4]==0x01||packet.keycode[4]==0x02||packet.keycode[4]==0x08||packet.keycode[4]==0x20||packet.keycode[4]==0x04||packet.keycode[4]==0x10){ 
				
					start = 1;
					game_over = 0;
					message[255] = 0;
				}
				if (message[255] == 0 && message[240] > 0) {

					if (packet.keycode[3] == 0x4f) {
						down_d = 1;
					}
					if (packet.keycode[3] == 0xcf) {
						leftdown_d = 1;
					}
					if (packet.keycode[3] == 0x8f) {
						left_d = 1;
					}
					if (packet.keycode[3] == 0x9f) {
						leftup_d = 1;
					}
					if (packet.keycode[3] == 0x1f) {
						up_d = 1;
					}
					if (packet.keycode[3] == 0x3f) {
						rightup_d = 1;
					}
					if (packet.keycode[3] == 0x2f) {
						right_d = 1;
					}
					if (packet.keycode[3] == 0x6f) {
						rightdown_d = 1;
					}

					if (packet.modifiers == 0x00) {
						if (packet.reserved == 0x7f) {
							left = 1;
						}
						if (packet.reserved == 0x00) {
							leftup = 1;
						}
						if (packet.reserved == 0xff) {
							leftdown = 1;
						}
					}
					if (packet.modifiers == 0xff) {
						if (packet.reserved == 0x7f) {
							right = 1;
						}
						if (packet.reserved == 0x00) {
							rightup = 1;
						}
						if (packet.reserved == 0xff) {
							rightdown = 1;
						}
					}
					if (packet.modifiers == 0x7f) {
						if (packet.reserved == 0x00) {
							up = 1;
						}
						if (packet.reserved == 0xff) {
							down = 1;
						}
					}
				}
				write_directions(message);
				if (!game_over && start) {
					if (right == 1) {
						if (message[1] < 580) //640-64 message[1] is x coordinate of spaceship, 
						{
							message[1]++;
						}
					}
					if (left == 1) {
						if (message[1] != 32) //leftup
						{
							message[1]--;
						}
					}
					if (down == 1) {
						if (message[2] < 428) //480-64  
						{
							message[2]++;
						}
					}
					if (up == 1) {
						if (message[2] != 32) //message[2] is the y coordinate
						{
							message[2] = message[2] - 1;
						}
					}
					if (leftup == 1) {
						if (message[2] != 32) {
							message[2] = message[2] - 1;
						}
						if (message[1] != 32) {
							message[1]--;
						}
						usleep(7500);
					}
					if (leftdown == 1) {
						if (message[2] < 428) {
							message[2]++;
						}
						if (message[1] != 32) {
							message[1]--;
						}
						usleep(7500);
					}
					if (rightdown == 1) {
						if (message[2] < 428) {
							message[2]++;
						}
						if (message[1] < 580) {
							message[1]++;
						}
						usleep(7500);
					}
					if (rightup == 1) {
						if (message[2] != 32) {
							message[2] = message[2] - 1;
						}
						if (message[1] < 580) {
							message[1]++;
						}

						usleep(7500);
					}
					//===================================================================
					//end of avatar position control
					//===================================================================

					//bullet data generation 
					/* add counter to control the speed to enter the following for loop */
					if (counter_bullet == 15) { 
						int i;
						for (i = 4; i < 120; i = i + 4) //The bullet info start from message[4] 
						{
							//generate the id of the bullet
							if (message[i] == 0) {
								flag_bullet = 1;
								message[i] = BULLET; //define the id
								if (left_d == 1) {
									message[i + 3] = LEFT;
								}
								if (leftup_d == 1) {
									message[i + 3] = LEFTUP;
								}
								if (leftdown_d == 1) {
									message[i + 3] = LEFTDOWN;
									usleep(7500);
								}
								if (down_d == 1) {
									message[i + 3] = DOWN;
								}
								if (right_d == 1) {
									message[i + 3] = RIGHT;
								}
								if (rightdown_d == 1) {
									message[i + 3] = RIGHTDOWN;
									usleep(7500);
								}
								if (rightup_d == 1) {
									message[i + 3] = RIGHTUP;
									usleep(7500);
								}
								if (up_d == 1) {
									message[i + 3] = UP;
								}
								switch (message[i + 3]) {
									case LEFT:
										{
											message[i + 1] = message[1] - 18;
											message[i + 2] = message[2] - 3; //bullet calibration [8]
											break;
										}
									case LEFTUP:
										{
											message[i + 1] = message[1] - 10;
											message[i + 2] = message[2] - 10;
											break;
										}
									case UP:
										{
											message[i + 1] = message[1] + 3;
											message[i + 2] = message[2] - 16;
											break;
										}
									case RIGHTUP:
										{
											message[i + 1] = message[1] + 15;
											message[i + 2] = message[2] - 10;
											break;
										}
									case RIGHT:
										{
											message[i + 1] = message[1] + 18;
											message[i + 2] = message[2];
											break;
										}
									case RIGHTDOWN:
										{
											message[i + 1] = message[1] + 10;
											message[i + 2] = message[2] + 10;
											break;
										}
									case DOWN:
										{
											message[i + 1] = message[1];
											message[i + 2] = message[2] + 16;
											break;
										}
									case LEFTDOWN:
										{
											message[i + 1] = message[1] - 10;
											message[i + 2] = message[2] + 10;
											break;
										}
									default:
										{
											message[i + 1] = message[1] - 16;
											message[i + 2] = message[2];
											break;
										}
								}
							}
							if (flag_bullet) {
								flag_bullet = 0;
								break;
							}

						}
						counter_bullet = 0;

					} else {
						counter_bullet++;
					}
					//===================================================================
					//end of bullet data generation control
					//===================================================================

					//===================================================================
					//enter spawn entity/enemy generation
					//===================================================================

					counter_wait = random_number_generation_x();
					//control the speed of enermy generation
					if (counter_wait % 23 == 0) {    
						int q, z, spawn_counter = 0;;
						for (q = 120; q < 240; q = q + 4) //address start from the 30th, i start from 30*4	
						{
							if (message[q] == NO_ID) {
								message[q + 1] = random_number_generation_x();
								message[q + 2] = random_number_generation_y();
								for (z = 120; z < 240; z = z + 4) {
									if ((abs(message[q + 1] - message[z + 1]) >= 32 || abs(message[q + 2] - message[z + 2]) >= 32) && (abs(message[q] - message[1] >= 32))) //-----32
									{
										spawn_counter++;
									}
								}
								if (spawn_counter == 29) {
									message[q] = 3;
									flag_spawn = 1;
									spawn_counter = 0;
								} else {
									message[q] = 0;
									message[q + 1] = 0;
									message[q + 2] = 0;
									flag_spawn = 1;
									spawn_counter = 0;
								}
								message[q + 3] = 0;
							}
							if (flag_spawn) {
								flag_spawn = 0;
								break;
							}
						}
					}
					//===================================================================
					//end of generate spawn/enemy data generation and movement control
					//===================================================================

					//===================================================================
					//enter movement decision
					//===================================================================
					for (n = 4; n < 240; n = n + 4) //the last object start from message[236]
					{
						int a = 1, b = 1;
						int x_old, y_old;
						x_old = message[n + 1];
						y_old = message[n + 2];
						if (message[n] == NO_ID) {
							message[n + 1] = 0;
							message[n + 2] = 0;
							message[n + 3] = 0;
						}
						if (message[n] == BULLET) {
							if (message[n + 1] > 580 || message[n + 2] > 440 || message[n + 1] < 32 || message[n + 2] < 32) {
								message[n] = NO_ID;
							} else if (message[n + 3] == LEFT) {
								message[n] = BULLET;
								message[n + 1] = message[n + 1] - 4;
								message[n + 2] = message[n + 2];
								message[n + 3] = message[n + 3];
							} else if (message[n + 3] == LEFTUP) {
								message[n] = BULLET;
								message[n + 1] = message[n + 1] - 4;
								message[n + 2] = message[n + 2] - 4;
								message[n + 3] = message[n + 3];
							} else if (message[n + 3] == LEFTDOWN) {
								message[n] = BULLET;
								message[n + 1] = message[n + 1] - 4;
								message[n + 2] = message[n + 2] + 4;
								message[n + 3] = message[n + 3];
							} else if (message[n + 3] == DOWN) {
								message[n] = BULLET;
								message[n + 1] = message[n + 1];
								message[n + 2] = message[n + 2] + 4;
								message[n + 3] = message[n + 3];
							} else if (message[n + 3] == RIGHT) {
								message[n] = BULLET;
								message[n + 1] = message[n + 1] + 4;
								message[n + 2] = message[n + 2];
								message[n + 3] = message[n + 3];
							} else if (message[n + 3] == RIGHTDOWN) {
								message[n] = BULLET;
								message[n + 1] = message[n + 1] + 4;
								message[n + 2] = message[n + 2] + 4;
								message[n + 3] = message[n + 3];
							} else if (message[n + 3] == RIGHTUP) {
								message[n] = BULLET;
								message[n + 1] = message[n + 1] + 4;
								message[n + 2] = message[n + 2] - 4;
								message[n + 3] = message[n + 3];
							} else if (message[n + 3] == UP) {
								message[n] = BULLET;
								message[n + 1] = message[n + 1];
								message[n + 2] = message[n + 2] - 4;
								message[n + 3] = message[n + 3];
							}
						} else if (message[n] == SPAWN) {
							if (message[n + 1] > 580 || message[n + 2] > 440 || message[n + 1] < 32 || message[n + 2] < 32) // when out of board, turn into no_id immediately
							{
								message[n] = NO_ID;
							}
							if (counter == 30) {

								if (message[n + 3] == 0) {

									message[n] = SPAWN;
									message[n + 1] = message[n + 1];
									message[n + 2] = message[n + 2];
									message[n + 3] = 1;
								} else if (message[n + 3] == 1) {
									message[n] = SPAWN;
									message[n + 1] = message[n + 1];
									message[n + 2] = message[n + 2];
									message[n + 3] = 2;
								} else if (message[n + 3] == 2) {
									message[n] = SPAWN;
									message[n + 1] = message[n + 1];
									message[n + 2] = message[n + 2];
									message[n + 3] = 3;
								} else if (message[n + 3] == 3) {
									switch (message[n + 1] % 4) {
										case 0:
											message[n] = ENEMY4;
											break;
										case 1:
											message[n] = ENEMY5;
											break;
										case 2:
											message[n] = ENEMY6;
											break;
										case 3:
											message[n] = ENEMY7;
											break;
										default:
											message[n] = ENEMY6;
											break;
									}
									message[n + 1] = message[n + 1];
									message[n + 2] = message[n + 2];
									message[n + 3] = 0;
								}
								counter = 0;
							} else counter++;
						}

						//SPAWN TURN INTO ENEMY4, bouncing ---bluecirle
						else if (message[n] == ENEMY4) {
							if (message[n + 1] > 580 || message[n + 2] > 440 || message[n + 1] < 32 || message[n + 2] < 32) {
								message[n] = NO_ID;
							} else {
								message[n] = ENEMY4;
								if (dr) message[n + 1] = message[n + 1] + a;
								else message[n + 1] = message[n + 1] - a;
								if (dd) message[n + 2] = message[n + 2] + a;
								else message[n + 2] = message[n + 2] - a;
								if (message[n + 1] >= 580) dr = 0;
								else if (message[n + 1] <= 64) dr = 1;
								if (message[n + 2] >= 440) dd = 0;
								else if (message[n + 2] <= 64) dd = 1;

							}
							message[n + 3] = 0;
						}

						//SPAWN TURN INTO ENEMY5, straight --- redcircle
						else if (message[n] == ENEMY5) {
							if (message[n + 1] > 580 || message[n + 2] > 440 || message[n + 1] < 32 || message[n + 2] < 32) {
								message[n] = NO_ID;
							} else {
								message[n] = ENEMY5;
								message[n + 1] = message[n + 1] - a;
								message[n + 2] = message[n + 2] + a;
							}
							message[n + 3] = 0;
						}

						//SPAWN  TURN  INTO ENEMY6, chase after the spaceship --triangle
						else if (message[n] == ENEMY6) {
							if (message[n + 1] > 580 || message[n + 2] > 440 || message[n + 1] < 32 || message[n + 2] < 32) {
								message[n] = NO_ID;
							}
							if (1) {
								message[n] = ENEMY6;
								if (message[1] >= message[n + 1]) {
									message[n + 1] = message[n + 1] + 1;
								} else {
									message[n + 1] = message[n + 1] - 1;
								}
								if (message[2] >= message[n + 2]) {
									message[n + 2] = message[n + 2] + 1;
								} else {
									message[n + 2] = message[n + 2] - 1;
								}
								movecounter = 0;
							}
							message[n + 3] = 0;
						}

						//SPAWN  TURN  INTO ENEMY7, chase----rectangular
						else if (message[n] == ENEMY7) {
							if (message[n + 1] > 580 || message[n + 2] > 440 || message[n + 1] < 32 || message[n + 2] < 32) {
								message[n] = NO_ID;
							}
							if (1) {
								message[n] = ENEMY7;
								if (message[1] >= message[n + 1]) {
									message[n + 1] = message[n + 1] - 1;
								} else {
									message[n + 1] = message[n + 1] + 1;
								}
								if (message[2] >= message[n + 2]) {
									message[n + 2] = message[n + 2] - 1;
								} else {
									message[n + 2] = message[n + 2] + 1;
								}
								movecounter = 0;
							}
							message[n + 3] = 0;
						} 
						else if (message[n] == EXPLOSION_BULLET) {
							if (message[n + 1] > 580 || message[n + 2] > 440 || message[n + 1] < 32 || message[n + 2] < 32) {
								message[n] = NO_ID;
							}
							if (counter == 30) {
								if (message[n + 3] == 0) {
									message[n] = EXPLOSION_BULLET;
									message[n + 1] = message[n + 1];
									message[n + 2] = message[n + 2];
									message[n + 3] = 1;
								} else if (message[n + 3] == 1) {
									message[n] = NO_ID;
									message[n + 1] = 0;
									message[n + 2] = 0;
									message[n + 3] = 0;
								}
								counter = 0;
							} else counter++;
						} else if (message[n] == NO_ID) {
							message[n] = 0;
							message[n + 1] = 0;
							message[n + 2] = 0;
							message[n + 3] = 0;
						}
					}

					//===================================================================
					//detect collision and added bombs
					//===================================================================
					int bomb_clear;
					for (j = 0; j < 120; j = j + 4) {
						for (k = 120; k < 240; k = k + 4) {
							if ((message[242] >= 0 && bomb == 1) || bomb_clear == 1) {
								message[k] = EXPLOSION_BULLET;
								bomb = 0;
								bomb_clear = 1;
								if (k == 236)
									bomb_clear = 0;
							} else {
								collision_result = collision(message[j], message[j + 1], message[j + 2], message[k], message[k + 1], message[k + 2]);
								if (collision_result == 1) { // a collision happens
									VGA_audio_collision = 1; 
									message[244] = VGA_audio_collision;
									if (message[j] == SPACESHIP) {
										life = life - 1;
										if (life == 0) {
											game_over = 1;
											message[244] = 0;
										}
										for (over = 0; over < 240; over = over + 4)
											message[over] = NO_ID;
									} else if (message[k] == ENEMY4 || message[k] == ENEMY5 || message[k] == ENEMY6 || message[k] == ENEMY7 || message[k] == SPAWN) {
										message[j] = NO_ID;
										message[k] = EXPLOSION_BULLET;
										message[k + 3] = 0;
										score = score + 1;
									} else if (message[k] == EXPLOSION_BULLET && message[k + 3] == 1) {
										message[j] = NO_ID;
										message[k] = NO_ID;
									} else if (message[k] == EXPLOSION_BULLET && message[k + 3] == 0) {
										message[j] = NO_ID;
										message[k] = EXPLOSION_BULLET;
									}
								}
							}
						}
					}
					if (VGA_audio_collision > 0) {
						message[244] = 1;
						VGA_audio_collision = 0;
					} else message[244] = 0;
					//===================================================================
					//end of detect collision
					//===================================================================
					
					//sending player informaiton
					//score conversion
					d = score % 10;
					t = ((score - d) / 10) % 10;
					h = ((score - 10 * t - d) / 100) % 10;
					message[246] = h; //hundreds
					message[247] = t; //tens
					message[248] = d; //digits
					message[240] = life;
					message[241] = score;
					message[255] = game_over;
				}
			}
		}
	}
	printf("VGA LED Userspace program terminating\n");
	return 0;
}
